/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWActionType;
import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.util.Enumeration;
import java.util.Hashtable;

public class VWFunctionStrings {
    private static Hashtable m_validFunctionTable = null;

    public static String[] getLocalizedStrings() {
        if (m_validFunctionTable == null) {
            m_validFunctionTable = new Hashtable();
            VWFunctionStrings.addString(m_validFunctionTable, 0);
            VWFunctionStrings.addString(m_validFunctionTable, 27);
            VWFunctionStrings.addString(m_validFunctionTable, 1);
            VWFunctionStrings.addString(m_validFunctionTable, 5);
            VWFunctionStrings.addString(m_validFunctionTable, 6);
            VWFunctionStrings.addString(m_validFunctionTable, 37);
            VWFunctionStrings.addString(m_validFunctionTable, 7);
            VWFunctionStrings.addString(m_validFunctionTable, 8);
            VWFunctionStrings.addString(m_validFunctionTable, 28);
            VWFunctionStrings.addString(m_validFunctionTable, 9);
            VWFunctionStrings.addString(m_validFunctionTable, 39);
            VWFunctionStrings.addString(m_validFunctionTable, 38);
            VWFunctionStrings.addString(m_validFunctionTable, 40);
            VWFunctionStrings.addString(m_validFunctionTable, 41);
            VWFunctionStrings.addString(m_validFunctionTable, 13);
            VWFunctionStrings.addString(m_validFunctionTable, 14);
            VWFunctionStrings.addString(m_validFunctionTable, 29);
            VWFunctionStrings.addString(m_validFunctionTable, 16);
            VWFunctionStrings.addString(m_validFunctionTable, 17);
            VWFunctionStrings.addString(m_validFunctionTable, 42);
            VWFunctionStrings.addString(m_validFunctionTable, 19);
        }
        String[] functionNames = new String[m_validFunctionTable.size()];
        int nIndex = 0;
        Enumeration myEnum = m_validFunctionTable.keys();
        while (myEnum.hasMoreElements()) {
            functionNames[nIndex++] = (String)myEnum.nextElement();
        }
        return functionNames;
    }

    public static String getLocalizedString(int nActionType) {
        String functionString = null;
        try {
            if (VWActionType.isValid(nActionType)) {
                switch (nActionType) {
                    case 1: 
                    case 8: 
                    case 9: 
                    case 13: 
                    case 16: {
                        functionString = VWResource.s_timerFunction.toString(VWActionType.getLocalizedString(nActionType));
                        break;
                    }
                    case 27: 
                    case 28: 
                    case 29: {
                        functionString = VWResource.s_checkpointFunction.toString(VWActionType.getLocalizedString(nActionType));
                        break;
                    }
                    case 19: {
                        functionString = VWResource.s_waitForCondition;
                        break;
                    }
                    default: {
                        functionString = VWActionType.getLocalizedString(nActionType);
                    }
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
        return functionString;
    }

    public static int getActionType(String localizedString) {
        if (localizedString != null) {
            Integer actionType;
            if (m_validFunctionTable == null) {
                VWFunctionStrings.getLocalizedStrings();
            }
            if (m_validFunctionTable != null && m_validFunctionTable.containsKey(localizedString) && (actionType = (Integer)m_validFunctionTable.get(localizedString)) != null) {
                return actionType;
            }
        }
        return -1;
    }

    private static void addString(Hashtable functionTable, int nActionType) {
        if (functionTable != null && VWActionType.isValid(nActionType)) {
            String key = VWFunctionStrings.getLocalizedString(nActionType);
            m_validFunctionTable.put(key, new Integer(nActionType));
        }
    }
}

